# Rexchristus College - Starter App

This ZIP contains a starter OOP PHP application (Auth, Admin users, Transcript with QR verification) using Bootstrap-based SB Admin 2 layout placeholders.

**Branding:** Rexchristus College

## Quick Setup

1. Upload the contents to your webroot (e.g., `/public_html/rexchristus/`).
2. Create the database and run migrations for the tables described below.
3. Update `classes/Database.php` with your DB credentials if different.

## Important DB tables (create or adapt if existing)

-- users (id, email, password, name, role, created_at)
-- students (your existing student table)
-- scores (your existing scores table)
-- transcript_verifications (admissionno, start_year, end_year, token, created_by)
-- audit_logs (user_id, action, details, ip, created_at)

## Notes
- QR generation uses `phpqrcode` (place library in `/phpqrcode/`).
- `qrcodes/` directory must be writable by PHP.
- SB Admin 2 CSS file is referenced in `admin/partials/header.php`. You can download the template assets and drop them into `assets/` or replace with CDN links.
- To enable PDF downloads, integrate Dompdf and call audit recording when generating PDF.
