<?php
class Database {
    protected static $instance = null;
    protected $conn = null;

    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $host = "localhost";
        $db   = "transcript";
        $user = "root";
        $pass = "";
        $dsn  = "mysql:host=$host;dbname=$db;charset=utf8mb4";
        try {
            $this->conn = new PDO($dsn, $user, $pass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);
        } catch (PDOException $e) {
            // In production, log this instead of echoing
            die("Database connection failed: " . $e->getMessage());
        }
    }

    public function getConnection() {
        return $this->conn;
    }

    public static function DisConnect($conn) {
        // PDO closes when out of scope; keep for compatibility
        $conn = null;
    }
}
