<?php
require_once __DIR__ . '/Database.php';

 
class UserModel extends Database {

    public function __construct() {

   }
    public function createUser($username, $name, $password, $role = 'staff') {
        $instance = parent::getInstance();
        $db = $instance->getConnection();
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $db->prepare("INSERT INTO users (username, password, name, role) VALUES (:e,:p,:n,:r)");
        $stmt->execute([':e'=>$username, ':p'=>$hash, ':n'=>$name, ':r'=>$role]);
        parent::DisConnect($db);
        return $db->lastInsertId();
    }

    public function deleteUser($id) {
        $instance = parent::getInstance();
        $db = $instance->getConnection();
        $stmt = $db->prepare("DELETE FROM users WHERE id = :id");
        $stmt->execute([':id'=>$id]);
        parent::DisConnect($db);
        return true;
    }

    public function listUsers() {
        $instance = parent::getInstance();
        $db = $instance->getConnection();
        $stmt = $db->query("SELECT id,username,name,role,created_at FROM users ORDER BY id DESC");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        parent::DisConnect($db);
        return $rows;
    }
}
