<?php
session_start();
require_once 'classes/Auth.php';
$auth = new Auth();
$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $pwd = $_POST['password'];
    if ($auth->attempt($username, $pwd)) {
        header('Location: admin/index.php');
        exit;
    } else {
        $err = 'Invalid credentials';
    }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Login - Rexchristus College</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
  <style>
    :root{
      --blue-600: #0d6efd;
      --blue-50: #eef6ff;
    }
    html,body{height:100%}
    body{
      font-family: "Inter", system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
      background: radial-gradient(circle at 10% 20%, rgba(13,110,253,0.08), transparent 10%),
                  linear-gradient(180deg, #f8fbff 0%, #f3f7ff 50%);
      display:flex;
      align-items:center;
      justify-content:center;
      padding:2rem;
    }
    .login-wrap{
      max-width:420px;
      width:100%;
    }
    .brand {
      display:flex;
      align-items:center;
      gap:.75rem;
      margin-bottom:1rem;
    }
    .brand .logo {
      width:56px;
      height:56px;
      background: linear-gradient(135deg,var(--blue-600),#4ea8ff);
      border-radius:12px;
      display:flex;
      align-items:center;
      justify-content:center;
      color:white;
      font-weight:700;
      box-shadow: 0 8px 20px rgba(13,110,253,0.12);
      font-size:20px;
    }
    .card {
      border: none;
      border-radius:12px;
      overflow:hidden;
      box-shadow: 0 10px 30px rgba(17,24,39,0.08);
    }
    .card-body{
      padding:2rem;
    }
    .form-control:focus{
      box-shadow: 0 0 0 0.15rem rgba(13,110,253,0.12);
      border-color: var(--blue-600);
    }
    .input-group-text{
      background: transparent;
      border-right:0;
      color:#6b7280;
    }
    .form-control{
      border-left:0;
    }
    .btn-primary{
      background: linear-gradient(90deg,var(--blue-600), #2b8cff);
      border: none;
      font-weight:600;
      padding: .6rem .9rem;
      border-radius:10px;
    }
    .muted-footer{font-size:.85rem;color:#6b7280;margin-top:.9rem}
    @media (max-width:576px){
      .login-wrap{padding:0 1rem}
      .card-body{padding:1.5rem}
    }
  </style>
</head>
<body>
  <div class="login-wrap">
    <div class="brand">
      <div class="logo">RC</div>
      <div>
        <h4 class="mb-0">Rexchristus College</h4>
        <small class="text-muted">Student Transcript Portal</small>
      </div>
    </div>

    <div class="card shadow-sm">
      <div class="card-body">
        <h5 class="card-title mb-3">Sign in</h5>

        <?php if($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>

        <form method="POST" novalidate>
          <div class="mb-3 input-group">
            <span class="input-group-text"><i class="fa-solid fa-user"></i></span>
            <input class="form-control" name="username" type="text" placeholder="username" required>
          </div>

          <div class="mb-3 input-group">
            <span class="input-group-text"><i class="fa-solid fa-lock"></i></span>
            <input class="form-control" type="password" name="password" placeholder="Password" required>
          </div>

          <div class="d-grid mb-2">
            <button class="btn btn-primary" type="submit">Login</button>
          </div>

          <div class="d-flex justify-content-between align-items-center">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" value="" id="remember">
              <label class="form-check-label" for="remember">Remember me</label>
            </div>
            <a href="#" class="small text-decoration-none">Forgot password?</a>
          </div>
        </form>
      </div>
    </div>

    <p class="text-center muted-footer">© <?= date('Y') ?> Rexchristus College — Secure access only</p>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
