<?php
require_once 'classes/Database.php';
$token = $_GET['token'] ?? '';
if (!$token) { echo "Invalid link"; exit; }
$instance = Database::getInstance();
$db = $instance->getConnection();
$stmt = $db->prepare("SELECT * FROM transcript_verifications WHERE token = :token LIMIT 1");
$stmt->execute([':token'=>$token]);
$rec = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$rec) {
    echo "<h3>❌ Invalid or expired token</h3>";
    exit;
}
$st = $db->prepare("SELECT fname,lname,class FROM students WHERE admissionno = :a LIMIT 1");
$st->execute([':a'=>$rec['admissionno']]);
$student = $st->fetch(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Verify Transcript - Rexchristus College</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
  <div class="container">
    <div class="card p-4 text-center">
      <h3 class="text-success">✅ Transcript Verified</h3>
      <p><strong>Admission No:</strong> <?= htmlspecialchars($rec['admissionno']) ?></p>
      <?php if($student): ?>
        <p><strong>Name:</strong> <?= htmlspecialchars($student['lname'].' '.$student['fname']) ?></p>
        <p><strong>Class:</strong> <?= htmlspecialchars($student['class']) ?></p>
      <?php endif; ?>
      <p><strong>Academic Years:</strong> <?= htmlspecialchars($rec['start_year']) ?> - <?= htmlspecialchars($rec['end_year']) ?></p>
      <p><strong>Issued On:</strong> <?= htmlspecialchars($rec['created_at']) ?></p>
    </div>
  </div>
</body>
</html>
